using log4net;
using Microsoft.AspNetCore.Mvc;
using Moq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Controllers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;
using Xunit;

namespace VA.PPMS.IWS.Api.Unit.Test
{
    public class CcnDataStreamControllerTests
    {
        [Fact]
        public void TestCcnDataStreamReturns201()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.Created)));

            var controller = new CcnDataStreamController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            const string payload = "<p:Providers xmlns:p='https://DNS.URL/exchange/ccn/1.0'><Provider><CorrelationID /><TransactionType>Update</TransactionType><FirstName>Anna</FirstName><LastName>Morgan-Test</LastName><ProviderId>1003000225</ProviderId><HealthProviderType>Radiology</HealthProviderType><Phone>510-752-1000</Phone><IsAcceptingNewPatients>true</IsAcceptingNewPatients><IsPrimaryCareProvider>true</IsPrimaryCareProvider><IsPrimaryCareProviderAcceptingVa>true</IsPrimaryCareProviderAcceptingVa><Address><Address1>275 W MacArthur</Address1><City>Oakland</City><State>CA</State><PostalCode>94611</PostalCode><County>Alameda</County><CountryCode>US</CountryCode></Address><Npis><Item><Number>1003000225</Number><EntityTypeCode>1-Individual</EntityTypeCode></Item></Npis><Tins><Item><Number>481192138</Number></Item></Tins><Specialties><Item><CodedSpecialty>174400000X</CodedSpecialty><IsPrimaryTaxonomy>true</IsPrimaryTaxonomy></Item></Specialties><ProviderServices><Item><CorrelationId /><CodedSpecialty>174400000X</CodedSpecialty><Location><CorrelationId /><Name>MacArthur Medical (Test)</Name><SiteAddress><Address1>275 W MacArthur</Address1><City>Oakland</City><State>CA</State><PostalCode>94611</PostalCode><County>Alameda</County><CountryCode>US</CountryCode></SiteAddress></Location></Item></ProviderServices><Licensures><Item><LicenseNumber>A92262</LicenseNumber><LicensingState>CA</LicensingState><ExpirationDate>2018-12-31</ExpirationDate></Item></Licensures></Provider></p:Providers>";
            
            // Act
            var results = controller.Post(payload);
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(201, statusCodeResult.StatusCode);
        }

        [Fact]
        public void TestCcnDataStreamReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new CcnDataStreamController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            const string payload = "<p:Providers xmlns:p='https://DNS.URL/exchange/ccn/1.0'><Provider><CorrelationID /><TransactionType>Update</TransactionType><FirstName>Anna</FirstName><LastName>Morgan-Test</LastName><ProviderId>1003000225</ProviderId><HealthProviderType>Radiology</HealthProviderType><Phone>510-752-1000</Phone><IsAcceptingNewPatients>true</IsAcceptingNewPatients><IsPrimaryCareProvider>true</IsPrimaryCareProvider><IsPrimaryCareProviderAcceptingVa>true</IsPrimaryCareProviderAcceptingVa><Address><Address1>275 W MacArthur</Address1><City>Oakland</City><State>CA</State><PostalCode>94611</PostalCode><County>Alameda</County><CountryCode>US</CountryCode></Address><Npis><Item><Number>1003000225</Number><EntityTypeCode>1-Individual</EntityTypeCode></Item></Npis><Tins><Item><Number>481192138</Number></Item></Tins><Specialties><Item><CodedSpecialty>174400000X</CodedSpecialty><IsPrimaryTaxonomy>true</IsPrimaryTaxonomy></Item></Specialties><ProviderServices><Item><CorrelationId /><CodedSpecialty>174400000X</CodedSpecialty><Location><CorrelationId /><Name>MacArthur Medical (Test)</Name><SiteAddress><Address1>275 W MacArthur</Address1><City>Oakland</City><State>CA</State><PostalCode>94611</PostalCode><County>Alameda</County><CountryCode>US</CountryCode></SiteAddress></Location></Item></ProviderServices><Licensures><Item><LicenseNumber>A92262</LicenseNumber><LicensingState>CA</LicensingState><ExpirationDate>2018-12-31</ExpirationDate></Item></Licensures></Provider></p:Providers>";

            // Act
            var results = controller.Post(payload);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
            Assert.Equal("Unable to process Providers for transaction: F911B4D4-BDB7-410C-8266-3EF4CD8DDD6F", statusCodeResult.Value);
        }
    }
}